using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml.Serialization;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Utilities;
using Microsoft.SharePoint.WebPartPages;
using System.Drawing;
using System.Web;
using System.Web.UI.HtmlControls;
using System.Collections;
using System.Web.SessionState;
using System.Security.Principal;
using System.IO;

namespace File_Control_Web_Part
{
	/// <summary>
	/// Description for FileControl_WebPart.
	/// </summary>
	[DefaultProperty("Text"),
		ToolboxData("<{0}:FileControl_WebPart runat=server></{0}:FileControl_WebPart>"),
		XmlRoot(Namespace="File_Control_Web_Part")]
	public class FileControl_WebPart : Microsoft.SharePoint.WebPartPages.WebPart,
		Microsoft.SharePoint.WebControls.IDesignTimeHtmlProvider 
	{
		#region Declarations
		protected System.Web.UI.WebControls.Label lblError;
		protected System.Web.UI.WebControls.Button btnUpload;
		protected System.Web.UI.WebControls.Button btnDelete;
		protected System.Web.UI.WebControls.ListBox lstDocs;
		protected System.Web.UI.HtmlControls.HtmlInputFile filePSE;
		protected System.Web.UI.WebControls.Image Image_View;

		private const string defaultSaveToPath = "";
		private const string defaultVirtualPath = "";
	
		private string SaveToPath = defaultSaveToPath;
		private string VirtualPath = defaultVirtualPath;

		public string All_Files = "";

		#endregion Declarations

		#region Properties

		#region SaveToPath
		[Browsable(true),
		Category("Miscellaneous"),
		DefaultValue(defaultSaveToPath),
		WebPartStorage(Storage.Personal),
		FriendlyName("SaveToLocation"),
		Description("Location where document will be saved.")]
		public string SaveToLocation
		{
			get
			{
				return SaveToPath;
			}

			set
			{
				SaveToPath = value;
			}
		}
		#endregion

		#region VirtualPath
		[Browsable(true),
		Category("Miscellaneous"),
		DefaultValue(defaultVirtualPath),
		WebPartStorage(Storage.Personal),
		FriendlyName("VirtualPathLocation"),
		Description("Virtual Path to launch document.")]
		public string VirtualPathLocation
		{
			get
			{
				return VirtualPath;
			}

			set
			{
				VirtualPath = value;
			}
		}
		#endregion

		#endregion Properties
		
		#region Customize ToolPane
		/// <summary>
		///  GetToolParts Method
		///	 Override the GetToolParts method
		///	 to control what is displayed in the tool pane
		///	 this Web Part is customized or personalized. 
		///	 Implement any custom tool parts in a separate class 
		///	 that derives from WebPartPages.ToolPart.
		///	</summary>
		/// <returns>An array of references to ToolPart objects.</returns>
		public override ToolPart[] GetToolParts()
		{
			// Modify the default tool pane property browser to show
			// the custom View category at the top and expanded.
			// No custom tool parts are used in this sample.
			// (Note that the DetialViewEnabled custom property 
			// would be displayed properly without overriding this method, 
			// but it would appear at the bottom of the  tool pane,
			// and the custom View property category would be collapsed.)
			
			// This method must return an array of ToolParts.
			ToolPart[] toolparts = new ToolPart[2];

			// The CustomPropertyToolPart will automatically
			// display the part's one custom property.
			CustomPropertyToolPart cp = new CustomPropertyToolPart();

			// Expand the custom View category, which was
			// created in an attribute of the property.
			cp.Expand("View");

			// Add the CustomPropertyToolPart to the array first
			// (by default it would be added last).
			toolparts[0] = cp;

			// Add a WebPartToolPart to automatically
			// display the standard WebPart properties.
			toolparts[1] = new WebPartToolPart();
			return toolparts;

		}
		#endregion
		
		#region Web Part rendering web part and create controls
		/// <summary>
		/// Render this Web Part to the output parameter specified.
		/// </summary>
		/// <param name="output"> The HTML writer to write out to </param>
		protected override void RenderWebPart(HtmlTextWriter output)
		{
			try
			{
				// table.
				output.AddAttribute(HtmlTextWriterAttribute.Width, "300px");
				output.AddAttribute(HtmlTextWriterAttribute.Cellpadding, "1px");
				output.AddAttribute(HtmlTextWriterAttribute.Cellspacing, "1px");
				output.AddAttribute(HtmlTextWriterAttribute.Border, "0");
				output.AddAttribute(HtmlTextWriterAttribute.Id , "Table1");
				output.RenderBeginTag("table");
			
				// begin <tr>
				output.RenderBeginTag("tr");

				// begin<td>
				output.RenderBeginTag("td");

				//div
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.FontWeight, "bold");
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.FontSize, "8pt");
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.Width, "136px");
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.Color , "#1e3c7b");
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.FontFamily, "Tahoma");
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.Height, "16px");
				output.AddStyleAttribute(System.Web.UI.HtmlTextWriterStyle.BackgroundColor, "transparent");
				output.RenderBeginTag("div");
				output.Write("Document(s) Attached");

				//end </div>
				output.RenderEndTag();

				// end </td>
				output.RenderEndTag();

				// end </tr>
				output.RenderEndTag();

				EnsureChildControls();

				#region Row 1
				// row 1
				output.RenderBeginTag("tr");
				
				// column 1
				output.RenderBeginTag("td");	
				this.lstDocs.RenderControl( output );
				
				//	end </td> column 1
				output.RenderEndTag(); 

				//	end row 1 </tr>
				output.RenderEndTag();
				
				#endregion

				#region Row 2
				// row 2
				output.RenderBeginTag("tr");
				
				// column 1
				output.RenderBeginTag("td");	
				this.filePSE.RenderControl( output );
				
				//	end </td> column 1
				output.RenderEndTag(); 

				//	end row 2 </tr>
				output.RenderEndTag();
				#endregion

				#region Row 3
				// row 3
				output.RenderBeginTag("tr");
				
				// column 1
				output.RenderBeginTag("td");	

				this.btnDelete.RenderControl( output );
				this.btnUpload.RenderControl( output );
				this.Image_View.RenderControl( output );
				
				//	end </td> column 1
				output.RenderEndTag(); 

				//	end row 3 </tr>
				output.RenderEndTag();
				#endregion

				#region Row 4
				// row 4
				output.RenderBeginTag("tr");
				
				// column 1
				output.RenderBeginTag("td");	

				this.lblError.RenderControl( output );
				
				//	end </td> column 1
				output.RenderEndTag(); 

				//	end row 4 </tr>
				output.RenderEndTag();
				#endregion

				// Close the table
				output.RenderEndTag();

			}
			catch( Exception error)
			{
				output.Write(SPEncode.HtmlEncode(error.Message.ToString()));
			}
		}

		protected override void CreateChildControls()
		{
			try
			{
				lstDocs = new ListBox();
				lstDocs.ID = "lstDocs";
				lstDocs.Width = System.Web.UI.WebControls.Unit.Parse("300px");
				lstDocs.Height = System.Web.UI.WebControls.Unit.Parse("56px");
				lstDocs.BorderWidth = System.Web.UI.WebControls.Unit.Parse("1px");
				lstDocs.ForeColor = System.Drawing.Color.FromName("#1E3C7B");
				lstDocs.BorderColor = Color.LightSteelBlue;
				lstDocs.BorderStyle = System.Web.UI.WebControls.BorderStyle.Solid;
				lstDocs.Font.Size = System.Web.UI.WebControls.FontUnit.Parse("8pt");
				lstDocs.Font.Name = "Tahoma";
				lstDocs.AutoPostBack = true;
				Controls.Add(lstDocs);
				lstDocs.SelectedIndexChanged +=new EventHandler(lstDocs_SelectedIndexChanged);
				

				filePSE = new HtmlInputFile();
				filePSE.ID = "filePSE";
				filePSE.Size = 32;
				Controls.Add(filePSE);

				//this.btnDelete 
				btnDelete = new Button();
				btnDelete.ID = "btnDelete";
				btnDelete.Width = System.Web.UI.WebControls.Unit.Parse("50px");
				btnDelete.Height = System.Web.UI.WebControls.Unit.Parse("20px");
				btnDelete.BorderWidth = System.Web.UI.WebControls.Unit.Parse("1px");
				btnDelete.ForeColor = System.Drawing.Color.FromName("#1E3C7B");
				btnDelete.BorderColor = Color.LightSteelBlue;
				btnDelete.BorderStyle = System.Web.UI.WebControls.BorderStyle.Solid;
				btnDelete.BackColor = Color.Ivory;
				btnDelete.Font.Size = System.Web.UI.WebControls.FontUnit.Parse("8pt");
				btnDelete.Font.Name = "Tahoma";
				btnDelete.Text = "Delete";
				btnDelete.Enabled = false;
				Controls.Add(btnDelete);
				btnDelete.Click +=new EventHandler(btnDelete_Click);

				//this.btnUpload 
				btnUpload = new Button();
				btnUpload.ID = "btnUpload";
				btnUpload.Width = System.Web.UI.WebControls.Unit.Parse("50px");
				btnUpload.Height = System.Web.UI.WebControls.Unit.Parse("20px");
				btnUpload.BorderWidth = System.Web.UI.WebControls.Unit.Parse("1px");
				btnUpload.ForeColor = System.Drawing.Color.FromName("#1E3C7B");
				btnUpload.BorderColor = Color.LightSteelBlue;
				btnUpload.BorderStyle = System.Web.UI.WebControls.BorderStyle.Solid;
				btnUpload.BackColor = Color.Ivory;
				btnUpload.Font.Size = System.Web.UI.WebControls.FontUnit.Parse("8pt");
				btnUpload.Font.Name = "Tahoma";
				btnUpload.Text = "Upload";
				btnUpload.Enabled = true;
				Controls.Add(btnUpload);
				btnUpload.Click +=new EventHandler(btnUpload_Click);

				//this.Image_View 
				Image_View = new System.Web.UI.WebControls.Image();
				Image_View.ID = "Image_View";
				Image_View.ForeColor = System.Drawing.Color.FromName("#1E3C7B");
				Image_View.ImageUrl = "http://fndev15mtcb/sites/ePACTS/images/ViewSelectedDocument.JPG";
				Controls.Add(Image_View);

				lblError = new Label();
				lblError.ID = "lblError";
				lblError.Width = System.Web.UI.WebControls.Unit.Parse("196px");
				lblError.Height = System.Web.UI.WebControls.Unit.Parse("20px");
				lblError.ForeColor = System.Drawing.Color.Red;
				lblError.BorderStyle = System.Web.UI.WebControls.BorderStyle.None;
				lblError.Font.Size = System.Web.UI.WebControls.FontUnit.Parse("8pt");
				lblError.Font.Name = "Tahoma";
				lblError.Text = "";
				lblError.Visible = true;
				Controls.Add(lblError);

				bool stat = true;

				if ( this.VirtualPath.Length == 0 )
				{
					this.lblError.Text = "Virtual Path Property has not been set.";
					this.lstDocs.Enabled = false;
					this.btnDelete.Enabled = false;
					this.btnUpload.Enabled = false;
					this.Image_View.Visible  = false;
					this.filePSE.Disabled = true;
					stat = false;
				}
				if (this.SaveToPath.Length == 0 )
				{
					this.lblError.Text = this.lblError.Text.ToString() + "<br>Save To Path Property has not been set.";
					this.lstDocs.Enabled = false;
					this.btnDelete.Enabled = false;
					this.btnUpload.Enabled = false;
					this.Image_View.Visible  = false;
					this.filePSE.Disabled = true;
					stat = false;
				}

				if ( stat == true )
				{

					this.lblError.Text = "";
					this.lstDocs.Enabled = true;
					this.btnDelete.Enabled = false;
					this.btnUpload.Enabled = true;
					this.Image_View.Visible  = true;
					this.filePSE.Disabled = false;
					ValidatePath ( SaveToPath );
					ShowAllFiles( SaveToPath );
				}
			}
			catch
			{
				return;
			}
			
		}

		#endregion
		
		#region Events
		private void btnUpload_Click(object sender, System.EventArgs e)
		{
			try
			{
				
				this.EnsureChildControls();
				if (filePSE.PostedFile.FileName == "") 
				{
					lblError.Text = "No file specified to upload";
					return; 
				} 
				string path = filePSE.PostedFile.FileName; 
				string doc_name = System.IO.Path.GetFileName(path.Trim()); 
				string err = ""; 

				bool isSafeFile = isFileSafe(ref doc_name,ref err, lstDocs);
				if (isSafeFile == false) 
				{ 
					lblError.Text = err; 
					return; 
				} 
				else 
				{ 
					lblError.Text = ""; 
				} 
				if (System.IO.Directory.Exists(this.SaveToPath) == false) 
				{ 
					try
					{
						System.IO.Directory.CreateDirectory(this.SaveToPath); 
					}
					catch
					{
						lblError.Text = "Unable to save document.  Please contact admin. (Error 11248)"; 
						return; 
					}
				} 
				filePSE.PostedFile.SaveAs(SaveToPath + "\\" + doc_name); 
				ListItem item = new ListItem(doc_name, SaveToPath + doc_name); 
				lstDocs.Items.Add(item); 
				EnableButtons(false); 
				Add_To_File_Collection(SaveToPath + doc_name); 
			}
			catch
			{
				return;
			}

		}
		private void lstDocs_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			try
			{
				this.EnsureChildControls();
				string link = this.VirtualPath + this.lstDocs.SelectedItem.Text.ToString(); 
				link = link.Replace( @"\", @"/");
				EnableButtons(true);
				Image_View.Visible = true;
				Image_View.Attributes.Add("onclick", "javascript:window.open('" + link + "'," + "'Document','height=500,width=500,toolbar=no,directories=no,status=no,menubar=yes,scrollbars=yes,resizable=yes,screenX=0,screenY=0,left=50,top=100')");
				Image_View.Attributes.Add("onmouseover", "this.style.cursor='hand';");
				Image_View.Attributes.Add("onmouseout", "this.style.cursor='hand';");

			}
			catch
			{
				return;
			}
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			try
			{
				try
				{
					this.EnsureChildControls();
					ListItem i = lstDocs.SelectedItem; 
					System.IO.File.Delete(i.Value.ToString() ); 
					this.Delete_From_File_Collection ( i.Value.ToString()); 
					lstDocs.Items.RemoveAt(lstDocs.SelectedIndex); 
					lblError.Text = "";
				
				}
				catch( Exception e1)
				{
					lblError.Text = "Unable to remove file.  Contact admin.  (Error: " + e1.Message.ToString(); 
				}
				finally
				{ 
					EnableButtons(false); 
				}
			}
			catch
			{
				return;
			}
		}

		#endregion
		
		#region File Control Methods
		private bool isFileSafe(ref string filename, ref string err, ListBox list) 
		{
			try
			{
				this.EnsureChildControls();
				Int32 dot_locator; 

				filename = filename.Trim(); 
				string temp = filename; 
			
				dot_locator = temp.LastIndexOf(".");
			
				if (dot_locator < 0) 
				{ 
					err = "<li>The filename requires a file extension"; 
					return false; 
				} 
		
				foreach (char ch in temp) 
				{
					if ( (ch.ToString() != ".") && (ch.ToString() != "-") && (ch.ToString() != "_") && (ch.ToString() != " "))
					{
						if (char.IsLetterOrDigit(ch) == false) 
						{ 
							err = "<li>Invalid filename.  The file name may have a symbol on it."; 
							return false; 
						}
					}
				} 
				if (temp.Length == 0) 
				{ 
					err = "<li>Invalid filename."; 
					return false; 
				} 
				if (temp != "") 
				{ 
					foreach (ListItem li in list.Items) 
					{ 
						if (li.Text == filename) 
						{ 
							err = "<li>This document already exists"; 
							return false; 
						} 
					} 
				} 
				return CheckExtensions(ref filename, ref err) ; 
			}
			catch( Exception error )
			{
				lblError.Text = error.Message.ToString();
				return false;
			}
		}
		private bool CheckExtensions(ref string filename, ref string err)
		{
			try
			{
				if ( (filename.ToLower().LastIndexOf(".doc") == -1) &&
					(filename.ToLower().LastIndexOf(".pdf") == -1) &&
					(filename.ToLower().LastIndexOf(".ppt") == -1) &&
					(filename.ToLower().LastIndexOf(".txt") == -1) &&
					(filename.ToLower().LastIndexOf(".xls") == -1)	)
				{
					err = "This type of file cannot be uploaded.";
					return false;
				}
				else
				{
					return true;
				}
			}
			catch( Exception error )
			{
				lblError.Text = error.Message.ToString();
				return false;
			}
		}

		private void ShowAllFiles( string SaveToPath )
		{
			try
			{
				this.EnsureChildControls();
				ListItem tempItem; 
				string doc_name = "";
				lstDocs.Items.Clear();
				
				string [] subfiles = Directory.GetFiles(SaveToPath);
				foreach ( string file_obj in subfiles)
				{
					doc_name = System.IO.Path.GetFileName(SaveToPath + file_obj);
					tempItem = new ListItem( doc_name, file_obj);
					lstDocs.Items.Add( tempItem );
				}
			}
			catch( Exception error )
			{
				lblError.Text = error.Message.ToString();
				return;
			}

		}

		public bool MoveAllFiles( string FromDirectory, string ToDirectory)
		{
			try
			{
				this.EnsureChildControls();
				if ( FromDirectory != ToDirectory )
				{
					this.ValidatePath( ToDirectory );
					
					string To = "";
					string From = "";
					string [] subfiles = Directory.GetFiles(FromDirectory);
					foreach ( string file_obj in subfiles)
					{
						From  = FromDirectory + System.IO.Path.GetFileName(file_obj);
						To  = ToDirectory + System.IO.Path.GetFileName(file_obj);
						System.IO.File.Copy( From, To, true);
						System.IO.File.Delete( From );
					}

					Directory.Delete( FromDirectory );
				}
				return true;
			}
			catch( Exception error )
			{
				lblError.Text = error.Message.ToString();
				return false;
			}
		}
		private void EnableButtons(bool val) 
		{ 
			try
			{
				this.EnsureChildControls();
				Image_View.Enabled = val; 
				btnDelete.Enabled = val; 
				if (val == false) 
				{ 
					lstDocs.SelectedIndex = -1; 
				}
			}
			catch( Exception error )
			{
				lblError.Text = error.Message.ToString();
				return;
			}
		}

		private void ValidatePath( string DirectoryPath)
		{
			try
			{
				if (	!System.IO.Directory.Exists( DirectoryPath )	)
				{
					System.IO.Directory.CreateDirectory( DirectoryPath);
				}
			}
			catch( Exception error )
			{
				lblError.Text = error.Message.ToString();
				return;
			}
		}
		private void Delete_From_File_Collection(string FileInfo) 
		{
			try
			{
				if ( All_Files.Length != 0 )
				{
					FileInfo = FileInfo.ToLower();
					All_Files = All_Files.ToLower();
					All_Files = All_Files.Replace(FileInfo, ""); 
					All_Files = All_Files.Replace(",,", ","); 

				}
			}
			catch( Exception error )
			{
				this.EnsureChildControls();
				lblError.Text = error.Message.ToString();
				return;
			}
		} 

		private void Add_To_File_Collection(string FileInfo) 
		{ 
			try
			{
				if ( All_Files.Length == 0 )
				{
					All_Files = FileInfo;
				}
				else
				{
					All_Files = All_Files + "," + FileInfo; 
				}
			}
			catch( Exception error )
			{
				this.EnsureChildControls();
				lblError.Text = error.Message.ToString();
				return;
			}
		} 

		public string Get_All_Files() 
		{ 
			try
			{
				if (All_Files.Length > 0) 
				{ 
					if (All_Files[All_Files.Length - 1].ToString() == ",") 
					{ 
						All_Files.Remove(All_Files.Length - 1, 1); 
					} 
				} 
				return All_Files; 
			}
			catch( Exception error )
			{
				this.EnsureChildControls();
				lblError.Text = error.Message.ToString();
				return "";
			}
		}

		#endregion

		#region Design Time HTML
		public string GetDesignTimeHtml()
		{
			System.Text.StringBuilder sb = new System.Text.StringBuilder(10000);
			System.IO.StringWriter sw = new System.IO.StringWriter(sb);
			HtmlTextWriter htw = new HtmlTextWriter(sw);
			try
			{
				this.RenderWebPart(htw);
				return sb.ToString();
			}
			catch(Exception e)
			{
				htw.Write(e.ToString());
				throw e;
			}
		}
		#endregion
	}
}
